/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.utils.TGResourceUtil;

public class ResourceTGValueModifier
implements TGValueModifier {
    private final TGResourceUtil util = new TGResourceUtil();
    private final SerialisationSupport ss;

    public ResourceTGValueModifier(SerialisationSupport ss) {
        this.ss = ss;
    }

    @Override
    public boolean mayNeedModification(Datatype type) {
        return this.util.mayHaveResource(type);
    }

    @Override
    public Object modify(final DomainProcessorState state, Binding binding, Object value) throws DatabaseException {
        try {
            this.util.adaptValue(binding, value, new TGResourceUtil.LongAdapter(){

                public long adapt(long in) {
                    try {
                        int shortId = ResourceTGValueModifier.this.ss.getTransientId(in);
                        return state.ids.get(shortId);
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                        return in;
                    }
                }
            });
            return value;
        }
        catch (AccessorException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

