/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.DatabaseExceptionUtils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLAction
implements ActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLAction.class);
    private final Resource rule;

    public SCLAction(ReadGraph graph, Resource rule) throws DatabaseException {
        this.rule = rule;
    }

    @Override
    public Runnable create(Object target) {
        return new SCLActionRunnable(this.rule, (Resource)target);
    }

    static class RuleFunctionRequest
    extends ResourceRead<Function1<Resource, Object>> {
        protected RuleFunctionRequest(Resource rule) {
            super(rule);
        }

        public Function1<Resource, Object> perform(ReadGraph graph) throws DatabaseException {
            Variable ruleVariable = Variables.getVariable(graph, this.resource);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return (Function1)ruleVariable.getPossiblePropertyValue(graph, L0.SCLAction_action);
        }
    }

    static class SCLActionRunnable
    implements Runnable {
        public final Resource rule;
        public final Resource target;

        public SCLActionRunnable(Resource rule, Resource target) {
            this.rule = rule;
            this.target = target;
        }

        @Override
        public void run() {
            Session s = SimanticsInternal.getSession();
            Resource resource = this.target;
            s.markUndoPoint();
            try {
                Function1 function = (Function1)s.syncRequest((Read)new RuleFunctionRequest(this.rule));
                function.apply((Object)resource);
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while executing action " + DatabaseExceptionUtils.showResource((RequestProcessor)s, resource), (Throwable)e);
            }
        }
    }
}

