/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleDiagram;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableInterface;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleSessionVariableFromURI
extends TernaryRead<ResourceArray, String, String, Variable> {
    public PossibleSessionVariableFromURI(ResourceArray resource, String identifier, String sessionId) {
        super((Object)resource, (Object)identifier, (Object)sessionId);
    }

    public Variable perform(ReadGraph graph) throws DatabaseException {
        try {
            Resource model;
            String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/CompositeToDiagram");
            Resource map = graph.getResource(uri);
            Resource tail = ((ResourceArray)this.parameter).tail();
            Resource head = ((ResourceArray)this.parameter).head();
            if (!graph.hasStatement(tail)) {
            }
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            String valuationName = null;
            Resource diagram = (Resource)graph.syncRequest((Read)new PossibleDiagram(tail));
            if (diagram == null) {
                Resource d = diagram;
                while ((d = graph.getPossibleObject(d, l0.PartOf)) != null) {
                    diagram = graph.getPossibleObject(d, map);
                    if (diagram != null) break;
                }
            }
            if (diagram != null) {
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                for (Resource run : graph.getObjects(diagram, l0.ConsistsOf)) {
                    String name = (String)graph.getPossibleRelatedValue(run, l0.HasName, (Binding)Bindings.STRING);
                    if (!((String)this.parameter2).equals(name)) continue;
                    valuationName = (String)graph.getPossibleRelatedValue(run, SIMU.HasActiveExperiment);
                    break;
                }
            }
            if ((model = (Resource)graph.syncRequest((Read)new PossibleModel(head))) == null) {
            }
            if (valuationName == null) {
                valuationName = "/ConfigurationValues";
            }
            VariableInterface variableInterface = (VariableInterface)graph.adapt(model, VariableInterface.class);
            Variable modelVariable = (Variable)graph.adapt(model, Variable.class);
            Variable experimentVariable = modelVariable.browse(graph, valuationName + (String)this.parameter2);
            return variableInterface.getVariable(graph, experimentVariable, (String)this.parameter3);
        }
        catch (MissingVariableException e) {}
        catch (ResourceNotFoundException e) {}
        catch (AdaptionException e) {}
        finally {
            return null;
        }
    }
}

