/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class ModelInstances
extends ResourceRead2<Map<String, Resource>> {
    public ModelInstances(Resource modelPart, Resource type) {
        super(modelPart, type);
    }

    private Resource getModel(ReadGraph graph) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.resource, SIMU.Model)) {
            return this.resource;
        }
        return (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(this.resource));
    }

    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(this.resource2, Instances.class);
        if (query == null) {
            return Collections.emptyMap();
        }
        Resource model = this.getModel(graph);
        if (model == null) {
            return Collections.emptyMap();
        }
        Collection<Resource> queryResult = query.find(graph, model);
        if (queryResult.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Resource> result = new HashMap<String, Resource>(queryResult.size());
        for (Resource instance : queryResult) {
            String name = (String)graph.getRelatedValue(instance, L0.HasName, (Binding)Bindings.STRING);
            result.put(name, instance);
        }
        return result;
    }
}

