/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.simulation.ontology.SimulationResource;

public class ActiveRuns
extends ResourceRead<Collection<Variable>> {
    public ActiveRuns(ReadGraph graph, Variable model) throws DatabaseException {
        super(model.getRepresents(graph));
    }

    public ActiveRuns(Resource model) {
        super(model);
    }

    public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
        Variable variable = Variables.getPossibleVariable(graph, this.resource);
        if (variable == null) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        for (Variable experiment : variable.getChildren(graph)) {
            Resource experimentType = experiment.getPossibleType(graph, SIMU.Experiment);
            if (experimentType == null) continue;
            for (Variable run : experiment.getChildren(graph)) {
                Resource represents;
                Resource runType = run.getPossibleType(graph);
                if (runType == null || !graph.isInheritedFrom(runType, SIMU.Run) || !graph.hasStatement(represents = run.getRepresents(graph), SIMU.IsActive)) continue;
                result.add(run);
            }
        }
        return result;
    }
}

