/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation.combinators;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;

public class SelectByRelation
extends AbstractRelation {
    GenericRelation base;
    int baseLength;
    String bindingPattern;
    int[] boundPositions;
    GenericRelation constraint;

    public SelectByRelation(GenericRelation base, String bindingPattern, GenericRelation constraint) {
        this.base = base;
        this.bindingPattern = bindingPattern;
        TIntArrayList boundPositionArray = new TIntArrayList();
        this.baseLength = bindingPattern.length();
        int i = 0;
        while (i < this.baseLength) {
            if (bindingPattern.charAt(i) == 'b') {
                boundPositionArray.add(i);
            }
            ++i;
        }
        this.boundPositions = boundPositionArray.toArray();
        this.constraint = constraint;
    }

    private Object[] map(Object[] tuple) {
        Object[] result = new Object[this.boundPositions.length];
        int i = 0;
        while (i < result.length) {
            result[i] = tuple[this.boundPositions[i]];
            ++i;
        }
        return result;
    }

    @Override
    public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
        assert (tuple.length == this.baseLength);
        return this.base.contains(g, tuple) && this.constraint.contains(g, this.map(tuple));
    }

    @Override
    public Pair<String, String>[] getFields() {
        return this.base.getFields();
    }

    @Override
    public boolean isRealizable() {
        return this.base.isRealizable();
    }

    @Override
    public GenericRelation select(String bindingPattern, Object[] constants) {
        return new SelectByRelation(this.base.select(bindingPattern, constants), bindingPattern, this.constraint);
    }

    @Override
    public List<Object[]> realize(ReadGraph g) throws DatabaseException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] tuple : this.base.realize(g)) {
            if (!this.constraint.contains(g, this.map(tuple))) continue;
            result.add(tuple);
        }
        return result;
    }
}

