/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.layer0.Layer0;

public class TrashBinRemover
extends AbstractRemover {
    public TrashBinRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource project = SimanticsInternal.getProject();
        Resource parent = graph.getSingleObject(project, L0.PartOf);
        Resource trashBin = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)parent, (String)"TrashBin");
        if (trashBin == null) {
            throw new DatabaseException("TrashBin resource could not be located.");
        }
        graph.deny(this.resource, L0.PartOf);
        String oldName = (String)graph.getPossibleRelatedValue2(this.resource, L0.HasName);
        if (oldName != null) {
            String oldLabel = (String)graph.getPossibleRelatedValue2(this.resource, L0.HasLabel);
            if (oldLabel == null) {
                graph.claimLiteral(this.resource, L0.HasLabel, L0.HasLabel_Inverse, (Object)oldName);
            }
            graph.denyValue(this.resource, L0.HasName);
        }
        graph.claim(trashBin, L0.ConsistsOf, L0.PartOf, this.resource);
    }
}

