/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;

public class RelatedObjectRemover
extends AbstractRemover {
    Resource[] relations;

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI) throws DatabaseException {
        super(component);
        this.relations = new Resource[]{graph.getResource(relationURI)};
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI, String relationURI2) throws DatabaseException {
        this(graph, component, new String[]{relationURI, relationURI2});
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI, String relationURI2, String relationURI3) throws DatabaseException {
        this(graph, component, new String[]{relationURI, relationURI2, relationURI3});
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String ... relationURIs) throws DatabaseException {
        super(component);
        if (relationURIs.length == 0) {
            this.relations = Resource.NONE;
        } else {
            this.relations = new Resource[relationURIs.length];
            int i = 0;
            while (i < relationURIs.length) {
                this.relations[i] = graph.getResource(relationURIs[i]);
                ++i;
            }
        }
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        ArrayList<Resource> objects = new ArrayList<Resource>();
        Resource[] resourceArray = this.relations;
        int n = this.relations.length;
        int n2 = 0;
        while (n2 < n) {
            Resource relation = resourceArray[n2];
            for (Resource object : graph.getObjects(this.resource, relation)) {
                if (object.equals(this.resource)) continue;
                objects.add(object);
            }
            ++n2;
        }
        EntityRemover.remove(graph, this.resource);
        for (Resource object : objects) {
            RemoverUtil.remove(graph, object);
        }
    }
}

