/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter;

import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class LiteralVariableStringAdapter
implements Adapter<String, Variable> {
    public void adapt(AsyncReadGraph g, Resource source, final Variable variable, AsyncProcedure<String> procedure) {
        g.asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource literal = variable.getPossibleRepresents(graph);
                String label = (String)graph.getPossibleRelatedAdapter(literal, ((Layer0)graph.getService(Layer0.class)).HasLabel, String.class);
                if (label != null) {
                    return label;
                }
                String name = (String)graph.getPossibleRelatedValue(literal, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING);
                if (name != null) {
                    return name;
                }
                Object value = variable.getValue(graph);
                Formatter formatter = (Formatter)graph.getPossibleContextualAdapter(literal, (Object)variable, Variable.class, Formatter.class);
                if (formatter != null) {
                    return formatter.format(value);
                }
                return value == null ? "<no value>" : value.toString();
            }
        }, procedure);
    }
}

