package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

abstract public class NodeManagerVariableBuilder implements VariableBuilder {

    @Override
    public Variable buildChild(ReadGraph graph, Variable parent, VariableNode node, Resource child) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	String childName = graph.getRelatedValue(child, L0.HasName, Bindings.STRING);
        String sessionName = parent.getURI(graph) + "/" + childName;
        return createChild(graph, parent, sessionName, child);
    }
    
    protected Variable createChild(ReadGraph graph, Variable parent, String sessionName, Resource child) throws DatabaseException {
        NodeSupport<?> support = getNodeSupport(graph, sessionName);
        return new StandardGraphChildVariable(parent, new VariableNode(support, getRoot(graph, support, sessionName)), child);
    }

    @Override
    public Variable buildProperty(ReadGraph graph, Variable parent, VariableNode node, Resource subject, Resource predicate) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
    
    protected abstract NodeSupport<?> getNodeSupport(ReadGraph graph, String sessionName) throws DatabaseException;
    protected abstract Object getRoot(ReadGraph graph, NodeSupport<?> support, String sessionName) throws DatabaseException;

}
