package org.simantics.db.layer0.util;

import java.util.Arrays;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public class TGSourceRepresentation implements Representation {

	protected Resource[] resources;
	protected boolean ignoreVirtualResources = false;
	private TransferableGraphSource value = null;
	private TransferableGraphConfiguration2 configuration;
	
	public TGSourceRepresentation(Resource ... resources) {
		this.resources = resources;
	}

	public TGSourceRepresentation(boolean ignoreVirtualResources, Resource ... resources) {
		this.ignoreVirtualResources = ignoreVirtualResources;
		this.resources = resources;
	}

	public TGSourceRepresentation(TransferableGraphConfiguration2 configuration) {
		this.configuration = configuration;
	}

	public TGSourceRepresentation(TransferableGraphSource value) {
		this.value = value;
	}

	@Override
	public Key getKey() {
		return SimanticsKeys.KEY_TRANSFERABLE_GRAPH_SOURCE;
	}

	public TransferableGraphSource compute(ReadGraph graph, Map<String,Object> hints) throws DatabaseException {
		
		if(configuration == null) {
			configuration = new TransferableGraphConfiguration2(graph, Arrays.asList(resources), ignoreVirtualResources, false);
			configuration.exclusionFunction = TGRepresentationUtils.computeExclusionFunction(graph, resources, hints);
		}
		
		return graph.syncRequest(new ModelTransferableGraphSourceRequest(configuration));
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) throws DatabaseException {
		
		if(value == null) {
			value = processor.syncRequest(new UniqueRead<TransferableGraphSource>() {

				@Override
				public TransferableGraphSource perform(ReadGraph graph) throws DatabaseException {
					return compute(graph, hints);
				}

			});
		}
		
		return (T)value;
		
	}
	
}