package org.simantics.db.layer0.util;

import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.graph.utils.TGResourceUtil.LongAdapter;

public class ResourceTGValueModifier implements TGValueModifier {

	final private TGResourceUtil util = new TGResourceUtil();
	final private SerialisationSupport ss;
	
	public ResourceTGValueModifier(SerialisationSupport ss) {
		this.ss = ss;
	}
	
	@Override
	public boolean mayNeedModification(Datatype type) {
		return util.mayHaveResource(type);
	}

	@Override
	public Object modify(final DomainProcessorState state, Binding binding, Object value) throws DatabaseException {
		
		try {
			
			util.adaptValue( binding, value, new LongAdapter() {
				@Override
				public long adapt(long in) {
					try {
						int shortId = ss.getTransientId(in);
						return state.ids.get(shortId);
					} catch (DatabaseException e) {
						e.printStackTrace();
					}
					return in;
				}			
			});
			
			return value;
			
		} catch (AccessorException e) {
			
			throw new DatabaseException(e);
			
		}
		
	}

}
