/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.TreeMap;

import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.binary.RandomAccessBinary;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

public class DomainProcessorState {

    public TreeMap<String, Variant> extensions = new TreeMap<String, Variant>();
    public TIntIntHashMap inverses = new TIntIntHashMap();
    public TIntHashSet externals = new TIntHashSet();
    public TIntHashSet exportedPredicates = new TIntHashSet();
    public TIntIntHashMap ids = new TIntIntHashMap(100, 0.6f, -1, -1);
    public TIntHashSet pending = new TIntHashSet();

    public int statementCount;
    public int valueCount;
    public int id;

    public DataOutputStream statementsOutput;
    public RandomAccessBinary valueOutput;
    public TIntHashSet excludedShared;

    public RandomAccessBinary otherStatementsInput;
    public RandomAccessBinary valueInput; 

    public SubMonitor monitor;
    public TGValueModifier valueModifier;
    public ArrayList<ConsistsOfProcess.ConsistsOfProcessEntry> internalEntries;

}