package org.simantics.db.layer0.request;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.SessionModel;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.user.UserResource;

public class SetActiveSessionRole extends WriteRequest {
    
    final private Resource model;
    final private Resource role;
    
    public SetActiveSessionRole(RequestProcessor processor, Resource model, Resource role) {
        super(processor.getService(VirtualGraphSupport.class).getWorkspacePersistent("activations"));
        this.model = model;
        this.role = role;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        UserResource USER = UserResource.getInstance(graph);
        Resource session = graph.getService(SessionModel.class).getResource();
        
        if(session != null) {
            for(Resource selection : graph.getObjects(session, L0X.Session_HasRoleSelection)) {
                Resource selectionModel = graph.getPossibleObject(selection, USER.RoleSelection_HasModel);
                if(selectionModel.equals(model)) {
                    graph.deny(selection, USER.RoleSelection_HasRole);
                    graph.claim(selection, USER.RoleSelection_HasRole, role);
                    return;
                }
            }
        }
        
        Resource selection = graph.newResource();
        graph.claim(selection, L0.InstanceOf, null, USER.RoleSelection);
        graph.claim(selection, USER.RoleSelection_HasModel, model);
        graph.claim(selection, USER.RoleSelection_HasRole, role);
        graph.claim(session, L0X.Session_HasRoleSelection, selection);
        
    }

}
