/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleActiveExperimentPath extends ResourceRead<String> {

    public PossibleActiveExperimentPath(Resource model) {
        super(model);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {

        String result = null;
    	Layer0 b = Layer0.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        for(Resource config : graph.getObjects(resource, b.ConsistsOf)) {
            if(graph.isInstanceOf(config, SIMU.Experiment)) {
                for(Resource run : graph.getObjects(config, b.ConsistsOf)) {
                    if(graph.isInstanceOf(run, SIMU.Run)) {
                        if(graph.hasStatement(run, SIMU.IsActive)) {
                            if(result != null) return null;
                            result = "/" + graph.getPossibleRelatedValue(config, b.HasName, Bindings.STRING) + "/" + graph.getPossibleRelatedValue(run, b.HasName, Bindings.STRING);
                        }
                    }
                }
            }
        }

        return result;

    }

}
