package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class IsLinkedTo extends ResourceRead2<Boolean> {

	public IsLinkedTo(Resource resource, Resource resource2) {
		super(resource, resource2);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {
		if(resource.equals(resource2)) return true;
		Layer0 L0 = Layer0.getInstance(graph);
		Collection<Resource> links = graph.getObjects(resource, L0.IsLinkedTo);
		for(Resource link : links) {
			if(link.equals(resource2)) return true;
		}
		for(Resource link : links) {
			if(graph.syncRequest(new IsLinkedTo(link, resource2))) return true;
		}
		return false;
	}

}
