package org.simantics.db.layer0.migration;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.query.Path;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.refactoring.MappingSpecification.MappingRule;
import org.simantics.layer0.Layer0;

public class SLNamespaceMigrationStep extends NamespaceMigrationStep{

    public SLNamespaceMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        super(graph, step);
    }
    
    @Override
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Collection<Resource> roots = state.getProperty(MigrationStateKeys.CURRENT_ROOT_RESOURCES);
        if (roots.isEmpty())
            return;
        final PrintWriter log = MigrationUtils.getProperty(state, MigrationStateKeys.MESSAGE_LOG_WRITER, NullWriter.PRINT_INSTANCE);
        
        session.sync(new DelayedWriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                create(monitor, graph, roots, log);
            }
        });
    }
    
    private void create(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        MappingSpecification mappingSpec = new MappingSpecification(rules);
        
        log.println("## NameSpace migration for a Shared Library\n");
        Map<Path, Resource> pathMap = new HashMap<Path, Resource>();
        for (MappingRule mr : mappingSpec.rules) {
            if (!pathMap.containsKey(mr.from)) {
                String uri = mr.from.toString();
                Resource res = graph.getResource(uri);
                pathMap.put(mr.from, res);
                if (res == null)
                    log.print("Didn't find " + mr.from);
            }
            if (!pathMap.containsKey(mr.to)) {
                String uri = mr.to.toString();
                Resource res = graph.getResource(uri);
                pathMap.put(mr.to, res);
                if (res == null)
                    log.print("Didn't find " + mr.to);
            }
        }
        
        Layer0 L0 = Layer0.getInstance(graph);
        
        Deque<Resource> stack = new ArrayDeque<>();
        stack.addAll(roots);
        while (!stack.isEmpty()) {
            Resource r = stack.pop();
            stack.addAll(graph.getObjects(r, L0.ConsistsOf));
            for (MappingRule mr : mappingSpec.rules) {
                Resource fromPred = pathMap.get(mr.from);
                Resource toPred = pathMap.get(mr.to);
                if (fromPred == null || toPred == null)
                    continue;
                Collection<Statement> stms = graph.getStatements(r, fromPred);
                for (Statement stm : stms) {
                    if (!stm.isAsserted(r)) {
                        graph.deny(stm);
                        graph.claim(stm.getSubject(), toPred, stm.getObject());
                    }
                }
            }
        }
    }
    
    

}
