/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import java.util.Collection;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;

public interface PasteHandler extends IAdaptable {

    /**
     * Performs actions to paste data from the specified clipboard instance. The
     * target of pasting generally has something to do with the graph database
     * but not necessarily. The method must internally start transactions to
     * either read from or write to the graph database.
     * 
     * @param clipboard clipboard instance to paste data from
     * @throws DatabaseException
     */
    Collection<Resource> pasteFromClipboard(SimanticsClipboard clipboard) throws DatabaseException;

    /**
     * Performs actions to paste data from the specified clipboard instance
     * using the specified write transaction database handle. Just as in
     * {@link #pasteFromClipboard(SimanticsClipboard)} this pasting generally
     * does with the graph database. This method can be used for performing
     * copy/paste operations as a part of a write transaction.
     * 
     * @param graph the write transaction handle to use for writing the data
     * @param clipboard clipboard instance to paste data from
     * @throws DatabaseException
     * @since 1.8
     * 
     * @see Layer0Utils#copyTo(WriteGraph, org.simantics.db.Resource, org.simantics.db.Resource)
     */
    Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException;

}
