package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;


public class VariableRequests {

//	/*
//	 * Convenience method for getting the value of a named property.
//	 */
//	<T> T getPropertyValue(ReadGraph graph, String name) throws DatabaseException;
//	<T> T getPossiblePropertyValue(ReadGraph graph, String name) throws DatabaseException;
//	/*
//	 * Convenience method for getting the value of a named property.
//	 */
//	<T> T getPropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException;
//	<T> T getPossiblePropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException;

	public static <T> Read<T> getPossiblePropertyValue(Variable variable, String name) {
		return new BinaryRead<Variable, String, T>(variable, name) {

			@Override
			public T perform(ReadGraph graph) throws DatabaseException {
				return parameter.getPossiblePropertyValue(graph, parameter2);
			}
			
		};
	}
	
	public static <T> Read<T> getPossiblePropertyValue(Variable variable, String name, Binding binding) {
		return new TernaryRead<Variable, String, Binding, T>(variable, name, binding) {

			@Override
			public T perform(ReadGraph graph) throws DatabaseException {
				return parameter.getPossiblePropertyValue(graph, parameter2, parameter3);
			}
			
		};
	}
	
//	/*
//	 * Gets the value of the property. Binding is default.
//	 */
//	<T> T getValue(ReadGraph graph) throws DatabaseException;
//	<T> T getPossibleValue(ReadGraph graph) throws DatabaseException;
//	/*
//	 * Gets the value of the property. Binding is explicitly given.
//	 */
//	<T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException;
//	<T> T getPossibleValue(ReadGraph graph, Binding binding) throws DatabaseException;
//	
//	/*
//	 * Writes a value using the given binding
//	 */
//	void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException;
//	/*
//	 * Writes a value with default binding
//	 */
//	void setValue(WriteGraph graph, Object value) throws DatabaseException;
//
//	/*
//	 * Writes a value to the given property using the given binding
//	 */
//	void setPropertyValue(WriteGraph graph, String name, Object value, Binding binding) throws DatabaseException;
//	/*
//	 * Writes a value to the given property using the default binding
//	 */
//	void setPropertyValue(WriteGraph graph, String name, Object value) throws DatabaseException;
//	
//	// TODO methods?
//	
//	/*
//	 * Gets a named child of this variable. A child corresponds to a '/' in URI notation
//	 */
//	Variable getChild(ReadGraph graph, String name) throws DatabaseException;
//	Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException;
//	/*
//	 * Gets a named property of this variable. A property corresponds to a '#' in URI notation
//	 */
//	Variable getProperty(ReadGraph graph, String name) throws DatabaseException;	
//	Variable getPossibleProperty(ReadGraph graph, String name) throws DatabaseException;	
//	
//	/*
//	 * Browses all children of this variable.
//	 */
//	Collection<Variable> browseChildren(ReadGraph graph) throws DatabaseException;
//	/*
//	 * Browses all properties of this variable.
//	 */
//	Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException;
//
//	/*
//	 * Browses a single variable using the given suffix path. The suffix can contain various '/' and '#'. 
//	 */
//	Variable browse(ReadGraph graph, String suffix) throws DatabaseException;
//	Variable browsePossible(ReadGraph graph, String suffix) throws DatabaseException;
//
//	/*
//	 * Browses a single variable using the given configuration resource. 
//	 */
//	Variable browse(ReadGraph graph, Resource config) throws DatabaseException;
//	Variable browsePossible(ReadGraph graph, Resource config) throws DatabaseException;
//	
//	/*
//	 * Gets the requested interface associated to this variable if available.
//	 * Examples: 
//	 * -Resource
//	 * -Accessor
//	 * -Binding
//	 * 
//	 */
//	@Deprecated
//	<T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException;
//	
//	<T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException;
//	
//	/*
//	 * Gets the unique URI reference for this variable.
//	 */
//	String getURI(ReadGraph graph) throws DatabaseException;
	
	
}
