package org.simantics.db.layer0.variable;

import java.util.Collection;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.NonWritableVariableException;

public interface VariableProperties<Key> {

	/*
	 * Gets a named property of this variable. A property corresponds to a '#' in URI notation
	 */
	Variable getProperty(ReadGraph graph, Key key) throws DatabaseException;	
	Variable getPossibleProperty(ReadGraph graph, Key key) throws DatabaseException;	
	
	Collection<Variable> getProperties(ReadGraph graph, Key key) throws DatabaseException;

	/*
	 * Convenience method for getting the value of a named property.
	 */
	<T> T getPropertyValue(ReadGraph graph, Key key) throws DatabaseException;
	<T> T getPossiblePropertyValue(ReadGraph graph, Key key) throws DatabaseException;
	/*
	 * Convenience method for getting the value of a named property.
	 */
	<T> T getPropertyValue(ReadGraph graph, Key key, Binding binding) throws DatabaseException;
	<T> T getPossiblePropertyValue(ReadGraph graph, Key key, Binding binding) throws DatabaseException;
	
	/**
	 * Writes a value to the given property using the given binding.
	 * 
	 * @throws NonWritableVariableException if the variable is not writable
	 * @throws DatabaseException in any other error conditions 
	 */
	void setPropertyValue(WriteGraph graph, Key key, Object value, Binding binding) throws DatabaseException;
	/**
	 * Writes a value to the given property using the default binding based on
	 * the value class.
	 * 
	 * @throws NonWritableVariableException if the variable is not writable
	 * @throws DatabaseException in any other error conditions 
	 */
	void setPropertyValue(WriteGraph graph, Key key, Object value) throws DatabaseException;
	
}
