package org.simantics.db.layer0.variable;

public class VariableNode<Node> {
    public final NodeSupport<Node> support;
    public final Object node;
    private int hash;
    public VariableNode(NodeSupport<Node> support, Object node) {
    	assert(support != null);
        this.support = support;
        this.node = node;
    }
    
    private int computeHash() {
        return 31*support.hashCode() + 41*node.hashCode();
    }

    @Override
    public int hashCode() {
        if (hash == 0)
            hash = computeHash();
        return hash;
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof VariableNode))
            return false;
        VariableNode<?> r = (VariableNode<?>)object;
        if (r.hashCode() != hashCode())
            return false;
        return r.support.equals(support) && r.node.equals(node);
    }
    
}
