/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public interface VariableInterface {
	/*
	 * @param uri A full variable URI
	 */
	Variable getVariable(ReadGraph graph, String uri);
	/*
	 * @param base a resource with URI
	 * @param uri A relative variable URI
	 */
	Variable getVariable(ReadGraph graph, Resource base, String suffix);
	Variable getVariable(ReadGraph graph, Resource variable);
	/*
	 * A context-dependent object which encodes a variable
	 */
	<T> Variable getVariable(ReadGraph graph, T context) throws DatabaseException;
	<T> Variable getVariable(ReadGraph graph, Variable basedOn, T context) throws DatabaseException;
	
}
