package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public interface ValueAccessor {
    Object getValue(ReadGraph graph, Variable context) throws DatabaseException;
    Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException;
    void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException;
    void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException;
    Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException;
}
