package org.simantics.db.layer0.variable;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.EnumerationMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class StandardVariableModifier implements VariableModifier {

	final private static Binding datatype_binging = Bindings.getBindingUnchecked(Datatype.class);
	final public static StandardVariableModifier INSTANCE = new StandardVariableModifier();

	@Override
	public String isValid(Object newValue) {
		return null;
	}

	@Override
	public String isValid(Object newValue, Binding binding) {
		return null;
	}

	@Override
	public void modify(WriteGraph graph, Variable variable, Object value) throws DatabaseException {
		modify(graph, variable, value, null);
	}

	boolean isEnumeration(ReadGraph graph, Resource literal) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		Resource parent = graph.getPossibleObject(literal, L0.PartOf);
		if(parent == null) return false;
		return graph.hasStatement(parent, L0.Enumeration);
		
	}
	
	@Override
	public void modify(WriteGraph graph, Variable variable, Object value, Binding binding) throws DatabaseException {

		Variable parent = variable.getParent(graph);
		Resource container = parent.getPossibleRepresents(graph);
		if(container == null) return;
		
		Resource property = variable.getPossiblePredicateResource(graph);
		if(property == null) return;
		
//		Variable parent = variable.getPossiblePropertyValue(graph, Variables.PARENT);
//		Variable predicate = variable.getPossiblePropertyValue(graph, Variables.PREDICATE);
		
//		Resource container = parent.getPossiblePropertyValue(graph, Variables.REPRESENTS);
//		if(container == null) return;
//		Resource property = predicate.getPossiblePropertyValue(graph, Variables.REPRESENTS);
//		if(property == null) return;
	
		Statement object = graph.getPossibleStatement(container, property);
		if(object == null) return;
		
		Resource objectResource = object.getObject();
		if(isEnumeration(graph, objectResource)) {

			Layer0 L0 = Layer0.getInstance(graph);
			Resource type = graph.getSingleObject(objectResource, L0.PartOf);
			
			Map<String, Resource> enumMap = graph.syncRequest(new EnumerationMap(type));
			Resource newLiteral = enumMap.get(value);
			graph.deny(container, property, objectResource);
			graph.claim(container, property, newLiteral);
			
			return;
		}
		
		if(object.isAsserted(container)) {

			Layer0 L0 = Layer0.getInstance(graph);
			Resource type = graph.getPossibleType(objectResource, L0.Literal);

			Statement dt = graph.getPossibleStatement(objectResource, L0.HasDataType);
			Datatype custom = dt.isAsserted(objectResource) ? null : (Datatype)graph.getValue(dt.getObject(), datatype_binging);

			objectResource = graph.newResource();
			graph.claim(objectResource, L0.InstanceOf, null, type);
			graph.claim(container, property, objectResource);
			if(custom != null) {
				graph.addLiteral(objectResource, L0.HasDataType, L0.HasDataType_Inverse, L0.DataType, custom, datatype_binging);
			}
			
			
//			Resource usesUnit = graph.getPossibleResource("http://flowbat.fi/Flowbat-0.1/UsesDatatype");
//			if(usesUnit != null) {
//				String unit = graph.getPossibleRelatedValue(oldObject, usesUnit, Bindings.STRING);
//				if(unit != null) {
//					graph.claimLiteral(objectResource, usesUnit, unit, Bindings.STRING);
//				}
//				Resource isDefault = graph.getResource("http://flowbat.fi/Flowbat-0.1/IsDefault");
//				Resource isUndefined = graph.getResource("http://flowbat.fi/Flowbat-0.1/IsUndefined");
//				graph.claimLiteral(objectResource, isDefault, false, Bindings.BOOLEAN);
//				graph.claimLiteral(objectResource, isUndefined, false, Bindings.BOOLEAN);
//			}
			
		}
		graph.claimValue(objectResource, value, binding);
		
	}
	

}
