/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.db.Resource;

public class ResourceX implements VariableOrResource {
    
    public final Resource value;

    public ResourceX(Resource value) {
        this.value = value;
    }
    
    @Override
    public String toString() {
        return "ResourceX " + value;
    }
    
    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null || obj.getClass() != getClass())
            return false;
        ResourceX other = (ResourceX)obj;
        return value == null ? other.value == null : value.equals(other.value);
    }
    
    @Override
    public int hashCode() {
        return 31 * (value == null ? 0 : value.hashCode()) + 13532;
    }
    
}
