/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * Used for defining custom variable spaces in SCL.
 * See SCL module <code>Simantics/Variables</code> function
 * <code>createVariableMap :: [Resource] -> VariableMap</code>.
 *
 * @author Antti Villberg
 * @since 1.29.0
 */
public class ResourceCollectionVariableMap extends VariableMapImpl {

	final private Collection<Resource> resources;

	public ResourceCollectionVariableMap(Collection<Resource> resources) {
		this.resources = resources;
	}

	@Override
	public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map)
			throws DatabaseException {
		for(Resource resource : resources) {
			if(map == null) map = new HashMap<>();
			Variable child = new StandardGraphChildVariable(context, null, resource);
			map.put(child.getName(graph), child);
		}
		return map;
	}

}
