/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;

/**
 * Allows attaching a variable under another one to create custom hierarchies
 * from existing variables.
 * 
 * @author Antti Villberg
 * @since 1.36.0
 */
public interface ProxyVariableSupport {

    Variable attachTo(ReadGraph graph, Variable parent);
    Variable attachToRenamed(ReadGraph graph, Variable parent, String name);

}
