package org.simantics.db.layer0.variable;

import org.simantics.db.Resource;

public class ModelledVariablePropertyDescriptorImpl implements ModelledVariablePropertyDescriptor {
	final private Variable variable;
	final private Resource subject;
	final private Resource property;
	public ModelledVariablePropertyDescriptorImpl(Variable variable, Resource subject, Resource property) {
		this.variable = variable;
		this.subject = subject;
		this.property = property;
	}
	public Variable getVariable() {
		return variable;
	}
	public Resource getSubject() {
		return subject;
	}
	public Resource getProperty() {
		return property;
	}
	@Override
	public int hashCode() {
		return subject.hashCode() ^ 31*property.hashCode() ^ 41*variable.hashCode();
	}
	@Override
	public boolean equals(Object obj) {
		if(this == obj) return true;
		if(!(obj instanceof ModelledVariablePropertyDescriptorImpl)) return false;
		ModelledVariablePropertyDescriptorImpl other = (ModelledVariablePropertyDescriptorImpl)obj;
		if(!subject.equals(other.subject)) return false;
		if(!property.equals(other.property)) return false;
		return variable.equals(other.variable);
	}
}
