package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.service.ExternalOperation;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class ExternalSetValue implements ExternalOperation {

    @SuppressWarnings("rawtypes")
	final private NodeManager manager;
    final private Object node;
    final private Object oldValue;
    final private Object newValue;
    final private Binding binding;
    
    public ExternalSetValue(@SuppressWarnings("rawtypes") NodeManager manager, Object node, Object oldValue, Object newValue, Binding binding) {
        this.manager = manager;
        this.node = node;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.binding = binding;
    }
    
    @SuppressWarnings("unchecked")
	@Override
    public void undo() {
        try {
            manager.setValue(node, oldValue, binding);
        } catch (NodeManagerException | BindingException e) {
            Logger.defaultLogError(e);
        }
    }

    @SuppressWarnings("unchecked")
	@Override
    public void redo() {
        try {
            manager.setValue(node, newValue, binding);
        } catch (NodeManagerException | BindingException e) {
            Logger.defaultLogError(e);
        }
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

}
