package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class ConstantValueStandardGraphPropertyVariable extends StandardGraphPropertyVariable {

	final private Object value;
	final private Datatype datatype;

	public ConstantValueStandardGraphPropertyVariable(ReadGraph graph, Variable parent, Resource parentResource, Resource predicate, Object value, Datatype datatype) throws DatabaseException {
		super(graph, parent, null, parentResource, predicate);
		this.value = value;
		this.datatype = datatype;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(ReadGraph graph) throws DatabaseException {
		return (T)value;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
		try {
			return (T)Bindings.adapt(value, Bindings.getBinding(datatype), binding);
		} catch (AdaptException e) {
			throw new DatabaseException(e);
		}
	}
	
	@Override
	public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
		return datatype;
	}

	@Override
	public void setValue(WriteGraph graph, Object value) throws DatabaseException {
		throw new DatabaseException("setValue is not supported.");
	}
	
	@Override
	public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
		throw new DatabaseException("setValue is not supported.");
	}
	
}
