/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.graph.db.TGStatusMonitor;

/**
 * @author Tuukka Lehtonen
 * @since 1.22.1 & 1.24.0
 */
public class TGProgressMonitor implements TGStatusMonitor {

    protected final IProgressMonitor monitor;
    private int lastPercentage = 0;

    public TGProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void status(int percentage) {
        if (percentage > lastPercentage) {
            monitor.worked(percentage - lastPercentage);
            workDone(percentage);
            lastPercentage = percentage;
        }
    }

    @Override
    public boolean isCanceled() {
        return monitor.isCanceled();
    }

    protected void workDone(int percentage) {
    }

}
