package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent.ExtentStatus;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2.SeedSpec;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2.SeedSpec.SeedSpecType;

public class TGConfigurer2 {

	final Collection<SeedSpec> seeds = new ArrayList<SeedSpec>();
	final Map<Resource, ExtentStatus> preStatus = new HashMap<Resource, ExtentStatus>();
	final boolean ignoreVirtualResources;
	final boolean validate;

	public TGConfigurer2(boolean ignoreVirtualResources, boolean validate) {
		this.ignoreVirtualResources = ignoreVirtualResources;
		this.validate = validate;
	}

	public TGConfigurer2 addInternalSeed(ReadGraph graph, Resource r) throws DatabaseException {

		// If parent is already an internal => skip this
		for(SeedSpec spec : seeds) {
			if(SeedSpecType.INTERNAL.equals(spec.specType)) {
				if(graph.syncRequest(new IsParent(spec.resource, r))) return this;
			}
		}
		// If some existing internal is a child of this one => remove them
		List<Resource> removals = new ArrayList<>();
		for(SeedSpec spec : seeds) {
			if(SeedSpecType.INTERNAL.equals(spec.specType)) {
				if(graph.syncRequest(new IsParent(r, spec.resource))) removals.add(spec.resource);
			}
		}
		for(Resource removal : removals) {
			SeedSpec spec = getSeed(removal);
			if(spec != null) {
				seeds.remove(spec);
			}
		}

		seeds.add(new SeedSpec(r, "", SeedSpecType.INTERNAL));

		return this;

	}

	private SeedSpec getSeed(Resource r) {
		for(SeedSpec spec : seeds) {
			if(spec.resource.equals(r)) return spec;
		}
		return null;
	}

	public TGConfigurer2 addExternal(Resource r) throws DatabaseException {
		preStatus.put(r, ExtentStatus.EXTERNAL);
		return this;
	}

	public TGConfigurer2 addExcluded(Resource r) throws DatabaseException {
		preStatus.put(r, ExtentStatus.EXCLUDED);
		return this;
	}

	public TransferableGraphConfiguration2 create() throws DatabaseException {
		return new TransferableGraphConfiguration2(null, seeds, preStatus, ignoreVirtualResources, validate);
	}

}
