/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.util.Collection;

import org.simantics.databoard.container.DataContainer;
import org.simantics.db.Resource;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * For dealing with clipboard-related keys listed in this class, see the 
 * utility methods listed as <code>see</code> in this class.
 * 
 * @see SimanticsInternal#getClipboard()
 * @see SimanticsClipboard#getContents()
 * @see ClipboardUtils#accept(java.util.Set, Key)
 * @see ClipboardUtils#accept(org.simantics.db.ReadGraph, java.util.Set, Key)
 */
public interface SimanticsKeys {

    /**
     * A key for storing the resource of the current project in an IHintContext.
     * This is used with ISessionContext.
     */
    Key KEY_PROJECT            = new KeyOf(Resource.class, "PROJECT_RESOURCE");

    /**
     * A key for storing the cut/copied transferable graph in a
     * {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_TRANSFERABLE_GRAPH = new KeyOf(TransferableGraph1.class, "TRANSFERABLE_GRAPH");

    /**
     * A key for storing the cut/copied transferable graph source in a
     * {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_TRANSFERABLE_GRAPH_SOURCE = new KeyOf(TransferableGraphSource.class, "TRANSFERABLE_GRAPH_SOURCE");

    /**
     * A key for storing the cut/copied DataContainer in a
     * {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_DATA_CONTAINER = new KeyOf(DataContainer.class, "DATA_CONTAINER");

    /**
     * A key for storing the original source {@link Resource} of a copy
     * operation in a {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_COPY_RESOURCES      = new KeyOf(Collection.class, "COPY_RESOURCE");

    /**
     * A key for storing the original source {@link Resource} of a cut operation
     * in a {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_CUT_RESOURCES       = new KeyOf(Collection.class, "CUT_RESOURCE");

    /**
     * A key for storing the original copied {@link Variable} in a
     * {@link SimanticsClipboard} instance as an available
     * {@link Representation} for the clipboard data.
     */
    Key KEY_VARIABLE           = new KeyOf(Variable.class, "VARIABLE");

}
