package org.simantics.db.layer0.util;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.LongType;
import org.simantics.db.exception.DatabaseException;

public enum RevisionTGValueModifier implements TGValueModifier {
    INSTANCE;
    
    public static final Long DEFAULT_VALUE = Long.valueOf(-1); 
    
    @Override
    public boolean mayNeedModification(Datatype type) {
        return type instanceof LongType 
                && "revision".equals(type.metadata.get("unit"));
    }

    @Override
    public Object modify(final DomainProcessorState state, Binding binding, Object value) throws DatabaseException {
        return DEFAULT_VALUE;
    }
}
