/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Statement;

final public class RelationContextImpl implements RelationContext {

    final private Resource subject;
    final private Statement statement;

    public RelationContextImpl(Resource subject, Statement statement) {
    	assert(subject != null);
    	assert(statement != null);
    	this.subject = subject;
    	this.statement = statement;
    }

    @Override
    public int hashCode() {
        return subject.hashCode() + 31 * statement.hashCode();
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (RelationContextImpl.class != object.getClass())
            return false;
        RelationContextImpl r = (RelationContextImpl)object;
        return subject.equals(r.subject) && statement.equals(r.statement);
    }

	@Override
	public Resource getSubject() {
		return subject;
	}

	@Override
	public Statement getStatement() {
		return statement;
	}

}
