/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.util.Collection;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.procedure.AsyncProcedure;

final public class DomainStatementProcedure2 implements AsyncProcedure<DirectStatements> {

	final private Collection<DirectStatements>[] results;

	public DomainStatementProcedure2(Collection<DirectStatements>[] results) {
		this.results = results;
	}

	@Override
	public void execute(AsyncReadGraph graph, final DirectStatements ds) {
		int thread = graph.thread();
		results[thread].add(ds);
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		throwable.printStackTrace();
	}

}
