/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.service;

import java.util.Collection;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Activation;

/**
 * Manages trigger activations.
 * This is a Session service. Acquire it 
 * by calling Session.getService(ActivationManager.class).
 */
public interface ActivationManager {
	
	/**
	 * Activates all triggers attached to the resource
	 * (by HasTrigger-relation). A trigger is active
	 * as long as there is one or more activations 
	 * referring to it. 
	 */
	Collection<Activation> activate(RequestProcessor processor, Resource resource) throws DatabaseException;
	
	//Activation activate(Resource resource);
	
}
