/*******************************************************************************
 * Copyright (c) 2012, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request.external;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Antti Villberg
 * @since 1.22.0
 */
public class EclipsePreferencePrimitiveRead extends ParametrizedPrimitiveRead<Pair<String,String>,String> implements IPreferenceChangeListener {

    private Listener<String> listener;

    public EclipsePreferencePrimitiveRead(String plugin, String key) {
        super(Pair.make(plugin, key));
    }

    @Override
    public void register(ReadGraph graph, Listener<String> procedure) {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (!procedure.safeIsDisposed() && preferenceNode != null) {
            preferenceNode.addPreferenceChangeListener(this);
        }
        listener = procedure;
        String value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
        if (value == null) {
            preferenceNode = resolveDefaultPreferenceNode();
            value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
        }
        procedure.execute(value);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        if (parameter.second.equals(event.getKey())) {
            IEclipsePreferences preferenceNode = resolvePreferenceNode();
            String value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
            if (value == null) {
                preferenceNode = resolveDefaultPreferenceNode();
                value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
            }
            listener.execute(value);
        }
    }

    @Override
    public void unregistered() {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (preferenceNode != null) {
            preferenceNode.removePreferenceChangeListener(this);
        }
        listener = null;
    }

    private IEclipsePreferences resolvePreferenceNode() {
        return InstanceScope.INSTANCE.getNode( parameter.first );
    }

    private IEclipsePreferences resolveDefaultPreferenceNode() {
        return DefaultScope.INSTANCE.getNode( parameter.first );
    }

}
