/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;

public class VariableIndexRoot extends UnaryRead<Variable, Resource> {

    public VariableIndexRoot(Variable variable) {
        super(variable);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {

    	Layer0 L0 = Layer0.getInstance(graph);
    	Resource r = parameter.getPossibleRepresents(graph);
    	if(r != null) {
    		if(graph.isInstanceOf(r, L0.IndexRoot)) return r;
    	}
    	
    	Variable parent = parameter.getParent(graph);
    	if(parent != null) return graph.sync(new VariableIndexRoot(parent));
    	else return null;

    }

}
