/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

 import gnu.trove.map.hash.THashMap;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 1.27.0
 */
public class UnescapedAssertedPropertyMapOfResource extends ResourceRead<Map<String, Pair<PropertyInfo, Resource>>> {

	private static final Logger LOGGER = LoggerFactory.getLogger(UnescapedAssertedPropertyMapOfResource.class);

	public UnescapedAssertedPropertyMapOfResource(Resource resource) {
		super(resource);
	}

	@Override
	public Map<String,Pair<PropertyInfo, Resource>> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		Collection<Statement> assertions = graph.getAssertedStatements(resource, L0.HasProperty); 
		THashMap<String, Pair<PropertyInfo, Resource>> result = new THashMap<>(assertions.size());
		for (Statement stm : assertions) {
			PropertyInfo info = graph.syncRequest(new PropertyInfoRequest(stm.getPredicate()), TransientCacheAsyncListener.<PropertyInfo>instance());
			if (info != null && info.isHasProperty) {
				String name = info.name;
				// Use putIfAbsent because we want to prefer the results that are first,
				// i.e. the ones deeper in the type inheritance chain.
				if (result.putIfAbsent(name, Pair.make(info, stm.getObject())) != null) {
					if (LOGGER.isDebugEnabled()) {
						LOGGER.debug(this + ": The database resource $" + resource.getResourceId()
								+ " asserts the multiple properties with the same name " + name + " (resource=$"
								+ info.predicate.getResourceId() + ").");
					}
				}
			}
		}
		return result;
	}

}
