/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * A request wrapper for {@link Variable#getPossibleValue(ReadGraph)}
 * @author Tuukka Lehtonen
 *
 * @param <T> result object type
 * @since 1.18.1
 */
public final class PossibleVariableValue<T> extends VariableRead<T> {

    public PossibleVariableValue(Variable variable) {
        super(variable);
    }

    @Override
    public T perform(ReadGraph graph) throws DatabaseException {
        return variable.getPossibleValue(graph);
    }

}
