/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleVariableModel extends VariableRead<Resource> {

	public PossibleVariableModel(Variable variable) {
		super(variable);
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {

		SimulationResource SIMU = SimulationResource.getInstance(graph);

		Resource represents = variable.getPossibleRepresents(graph);
		if(represents != null) {
			if(graph.isInstanceOf(represents, SIMU.Model)) return represents;
			if(graph.getRootLibrary().equals(represents)) return null;
		}

		return graph.syncRequest(new PossibleVariableModel(variable.getParent(graph)));

	}

}
