/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableInterface;

public class PossibleExperimentVariable extends BinaryRead<String, ResourceArray, Variable> {

    public PossibleExperimentVariable(String experiment, ResourceArray resource) {
        super(experiment, resource);
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {

        try {
        	
        	Resource tail = parameter2.tail();
        	Resource head = parameter2.head();

        	if(!graph.hasStatement(tail)) return null;
        	
        	String valuationName = parameter;
            
            Resource model = graph.syncRequest(new PossibleModel(head));
            if (model == null) return null;

            VariableInterface variableInterface = graph.adapt(model, VariableInterface.class);
            Variable modelVariable = graph.adapt(model, Variable.class);
            Variable experimentVariable = modelVariable.browse(graph, valuationName);
            return variableInterface.getVariable(graph, experimentVariable, parameter2);
            
        } catch (MissingVariableException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (Throwable e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }

}
