/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;

public class PossibleActiveVariableFromURI extends BinaryRead<Resource, String, Variable> {

    public PossibleActiveVariableFromURI(Resource model, String uri) {
        super(model, uri);
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {
        try {
        	String valuationName = null;
            
            Resource model = parameter;
            if (model == null) return null;

        	String valuation = graph.syncRequest(new PossibleActiveExperimentPath(model));
        	if(valuation != null) valuationName = valuation;

            if (valuationName == null) {
                valuationName = "/BaseRealization";
            }

            Variable modelVariable = graph.adapt(model, Variable.class);
            Variable experimentVariable = modelVariable.browse(graph, valuationName+parameter2);
            return experimentVariable;            
        } catch (MissingVariableException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (Throwable e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }

}
