package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class PossibleActiveRun extends ResourceRead<Variable> {

    public PossibleActiveRun(Resource model) {
        super(model);
    }

    public PossibleActiveRun(ReadGraph graph, Variable model) throws DatabaseException {
        super(model.getRepresents(graph));
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {

    	Collection<Variable> result = graph.sync(new ActiveRuns(resource));
    	if(result.size() == 1) return result.iterator().next();
    	else return null;

    }

}
