/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.Valuations;

public class PossibleActiveModelValuation extends BinaryRead<Resource, String, Resource> {

    public PossibleActiveModelValuation(Resource model) {
        super(model, "");
    }

    public PossibleActiveModelValuation(Resource resource, String suffix) {
        super(resource, suffix);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
    	
        try {

        	String valuationName = null;
        	
        	Valuations valuations = graph.adapt(parameter, Valuations.class);

        	String valuation = graph.syncRequest(new PossibleActiveExperimentPath(parameter));
        	if(valuation != null) valuationName = valuation;

        	if (valuationName == null) {
                valuationName = "BaseRealization";
            }

//        	System.out.println("possibleactivemodelvaluations uses valuation " + valuationName + " parameter2 = " + parameter2);
        	
            return valuations.getValue(graph, null, valuationName, parameter2);
            
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (Throwable e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }

}
