package org.simantics.db.layer0.request;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;

public class IndexedInstances extends ResourceRead2<Set<Resource>> {

	public IndexedInstances(Resource type, Resource indexRoot) {
		super(type, indexRoot);
	}

	@Override
	public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
		return new HashSet<>(QueryIndexUtils.searchByTypeShallow(graph, resource2, resource));
	}

}
