package org.simantics.db.layer0.request;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;

public class GlobalOntologies extends ResourceRead<List<Resource>> {

	public GlobalOntologies(Resource root) {
		super(root);
	}

	@Override
	public List<Resource> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		ArrayList<Resource> result = new ArrayList<Resource>();
		for(Resource ontology : Layer0Utils.listOntologies(graph)) {
			Boolean global = graph.getPossibleRelatedValue(ontology, L0.Ontology_global, Bindings.BOOLEAN);
			if(global != null && global) result.add(ontology);
		}
		return result;
	}

}
