/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * Get a map from GUIDs to the children of the given resource.
 */
public final class ChildrenByIdentifier extends ResourceRead<Map<GUID, Resource>> {
	public ChildrenByIdentifier(Resource resource) {
		super(resource);
	}

	@Override
	public Map<GUID, Resource> perform(ReadGraph graph) throws DatabaseException {
		Map<GUID, Resource> result = new HashMap<>();
		Layer0 L0 = Layer0.getInstance(graph);
		Collection<Resource> children = graph.getObjects(resource, L0.ConsistsOf);
		for (Resource child : children) {
			GUID guid = graph.getPossibleRelatedValue(child, L0.identifier, GUID.BINDING);
			if (guid != null)
				result.put(guid, child);
		}
		
		return result;
	}
}
