/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.migration;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.logging.TimeLogger;

public class MigrationSequence implements MigrationStep {
	
	final List<MigrationStep> steps;
	
	public MigrationSequence(ReadGraph graph, Resource sequence) throws DatabaseException {
		steps = new ArrayList<MigrationStep>();
		for(Resource step : ListUtils.toList(graph, sequence)) {
			MigrationStep ms = graph.adapt(step, MigrationStep.class);
			steps.add(ms);
		}
	}

	@Override
	public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
		TimeLogger.resetTimeAndLog(getClass(), "Running migration sequence");
		for(MigrationStep step : steps) {
			if(monitor.isCanceled()) return;
			TimeLogger.log(getClass(), "Running migration step: " + step.getClass() + " (" + step + ")");
			step.applyTo(monitor, session, state);
			if (monitor.isCanceled()) {
				TimeLogger.log(getClass(), "Migration cancelled during step: " + step.getClass() + " (" + step + ")");
				return;
			}
			monitor.subTask("");
			TimeLogger.log(getClass(), "Completed migration step: " + step.getClass() + " (" + step + ")");
		}
	}

}
